#include "BOLTApp.h"
#include "db/BOLTdb.h"
#include "db/BOLTdbConfig.h"

#include "ctrl/BOLTChooser.h"
#include "ctrl/BOLTUser.h"
//#include "ctrl/BOLTReport.h"
#include "BOLTFrm.h"
#include "form/BOLTforms.h"
#include "report/brRunner.h"
#include "report/brTarget.h"
#include "wx/statline.h"
#include <wx/cmndata.h>
#include "wx/printdlg.h"
enum {
 ID_NEW=13050,
 ID_EDIT,
 ID_DELETE,
 ID_LIST,
 ID_RUN
};

//IMPLEMENT_DYNAMIC_CLASS(brTarget,wxPanel)
BEGIN_EVENT_TABLE(brTarget,wxPanel)
EVT_BUTTON(ID_RUN,brTarget::OnRun)
EVT_BUTTON(ID_NEW,brTarget::OnNew)
EVT_BUTTON(ID_EDIT,brTarget::OnEdit)
EVT_BUTTON(ID_DELETE,brTarget::OnDelete)
EVT_LISTBOX(ID_LIST,brTarget::OnSelect)
EVT_LISTBOX_DCLICK(ID_LIST,brTarget::OnEdit)
END_EVENT_TABLE()

brTarget::brTarget(wxWindow *parent,BOLTdb *db, RECORD_ID recordId):
 wxPanel(parent,-1)
{	 
this->db=db;
this->recordId=recordId;
SetFont(parent->GetFont());

SetBackgroundColour(parent->GetBackgroundColour());

wxBoxSizer *topSizer;
wxBoxSizer *bSizer;
topSizer=new wxBoxSizer(wxVERTICAL);
topSizer->Add(new wxStaticText(this,-1,"Stored Reports"),0,wxALIGN_CENTER|wxALL,15);
topSizer->Add(new wxStaticLine(this,-1),0,wxEXPAND);

topSizer->Add(new wxListBox(this,ID_LIST),1,wxEXPAND|wxALL,10);

bSizer=new wxBoxSizer(wxHORIZONTAL);
bSizer->Add(new wxButton(this,ID_RUN,"&Run"),0,wxALIGN_CENTER|wxALL,5);
bSizer->Add(new wxButton(this,ID_NEW,"&New"),0,wxALIGN_CENTER|wxALL,5);
bSizer->Add(new wxButton(this,ID_EDIT,"&Edit"),0,wxALIGN_CENTER|wxALL,5);
bSizer->Add(new wxButton(this,ID_DELETE,"&Delete"),0,wxALIGN_CENTER|wxALL,5);
topSizer->Add(bSizer,0,wxALIGN_CENTER|wxALL,2);
//SetAutoLayout(TRUE);
SetSizerAndFit(topSizer);
FillList();
};

void brTarget::FillList()
{
	QRY_ID qry;
	void *row;
	char *tmp;
	wxString tStr;
	wxListBox *list;

	list=(wxListBox *)this->FindWindow(ID_LIST);
	if (!list) { return; }
	int cSel;
	cSel=list->GetSelection();
	list->Clear(); aId.Empty();
	tStr.Printf("select id,concat(name,' [runs ',if (trigger is null,'<nothing>',trigger),']') from storedReports order by name,id");
	if (qry=db->Query(tStr.c_str(),tStr.Length()))
	{
		while (row=db->FetchRow(qry))
		{
			tmp=db->FetchQueryResult(qry,row,0);
			aId.Add(atoi(tmp));
			tStr=db->FetchQueryResult(qry,row,1);
			list->Append(tStr);
		}
		db->FreeQuery(qry);
	}
	if (cSel>=list->Number())
		{ cSel=list->Number()-1; };
	if (cSel>-1)
		list->SetSelection(cSel,TRUE);
	OnSelect(wxCommandEvent(0,0));
}

void brTarget::OnNew(wxCommandEvent & event)
{
	wxString tStr;
	RECORD_ID newId;

	newId=db->NewRecord("storedReports");
	db->SetValue("storedReports","name",newId,"'New Stored Report'");
	brTargetEditor *brTE;
	brTE=new brTargetEditor(this,db,newId);
	brTE->Destroy();
	FillList();
};

void brTarget::OnEdit(wxCommandEvent & event)
{
	wxListBox *list;
	list=(wxListBox *)this->FindWindow(ID_LIST);
	if (!list) { return; }
	int sel=list->GetSelection();

	brTargetEditor *brTE;
	brTE=new brTargetEditor(this,db,(RECORD_ID)aId[sel]);
	brTE->Destroy();
	FillList();
	list->SetSelection(sel);
};

void brTarget::OnDelete(wxCommandEvent & event)
{
	wxListBox *list;
	wxString tStr;
	if (wxMessageBox("Are you sure you would like to delete this stored report ?","Confirm Delete",wxYES_NO,this)==wxNO)
		{ return; }
	list=(wxListBox *)this->FindWindow(ID_LIST);
	if (!list) { return; }
	int sel=list->GetSelection();
	if ((sel<0) || (!aId[sel])) { return; }

	tStr.Printf("delete from storedReports where id=%u",
			aId[sel]);
	db->FreeQuery(db->Query(tStr.c_str(),tStr.Length()));
	FillList();
};

void brTarget::OnSelect(wxCommandEvent &event)
{
wxListBox *list;
int max,sel;
list=(wxListBox *)this->FindWindow(ID_LIST);
max=list->Number()-1;
sel=list->GetSelection();

this->FindWindow(ID_NEW)->Enable(TRUE);
this->FindWindow(ID_RUN)->Enable((sel>=0)&&(sel<=max));
this->FindWindow(ID_EDIT)->Enable((sel>=0)&&(sel<=max));
this->FindWindow(ID_DELETE)->Enable((sel>=0)&&(sel<=max));
}


void brTarget::OnRun(wxCommandEvent &event)
{
	QRY_ID pQry;
	void *pRow;
	char *tmp;
	brRunner *runner;
	wxString tStr,tStr2,tStr3;
	RECORD_ID srId,tmpId;
	wxListBox *list;
	list=(wxListBox *)this->FindWindow(ID_LIST);
	if (!list) { return; }
	int sel=list->GetSelection();
	srId=(RECORD_ID)aId[sel];
	wxArrayString pArray;

	//progress dialog - 3 steps
wxString curQry;
	//step 1 - init query
	curQry=db->GetValue("storedReports","initQuery",srId);
	while (curQry.Find(';')>-1)
	{
		tStr=curQry.BeforeFirst(';');
		if (!tStr.IsEmpty())
			{db->FreeQuery(db->Query(tStr.c_str(),tStr.Length()));}
		tStr=curQry.AfterFirst(';');
		curQry=tStr;
	}
	if (!curQry.IsEmpty())
	{db->FreeQuery(db->Query(curQry.c_str(),curQry.Length()));}

	//step 2 - foreach param query - run report w/params
	tStr=db->GetValue("storedReports","ParamQuery",srId);
	if (tStr.IsEmpty())
	{
		runner=new brRunner(this,db,0);
		runner->TriggerReport(0,db->GetValue("storedReports","trigger",srId));
		safe_delete(runner);
	}
	else
	{
		if (pQry=db->Query(tStr.c_str(),tStr.Length()))
		{
			runner=new brRunner(this,db,0);
			while (pRow=db->FetchRow(pQry))
			{

				tStr=db->FetchQueryResult(pQry,pRow,0);
				pArray.Empty();
				pArray.Add(tStr);
				tStr.ToULong(&tmpId);
				unsigned int pCnt=0;
				while (db->FetchNumCols(pQry,pRow)>++pCnt)
				{
					if (tmp=db->FetchQueryResult(pQry,pRow,pCnt))
					{tStr=tmp; } else { tStr=""; }
					pArray.Add(tStr);
				}
				runner->TriggerReport(tmpId,db->GetValue("storedReports","trigger",srId),&pArray);
			}
			db->FreeQuery(pQry);
			safe_delete(runner);

		}
	}	
	//step 3 - cleanup query
	curQry=db->GetValue("storedReports","cleanQuery",srId);
	while (curQry.Find(';')>-1)
	{
		tStr=curQry.BeforeFirst(';');
		if (!tStr.IsEmpty())
			{db->FreeQuery(db->Query(tStr.c_str(),tStr.Length()));}
		tStr=curQry.AfterFirst(';');
		curQry=tStr;
	}
	if (!curQry.IsEmpty())
	{db->FreeQuery(db->Query(curQry.c_str(),curQry.Length()));}
}

enum { 
TE_CHOICE=18750,
ID_TRIGGER,
ID_NAME,
ID_INITQRY,
ID_PARAMQRY,
ID_CLEANQRY
};

//IMPLEMENT_DYNAMIC_CLASS(brTargetEditor,wxDialog)
BEGIN_EVENT_TABLE(brTargetEditor,wxDialog)
EVT_TEXT(ID_NAME,brTargetEditor::OnText)
EVT_TEXT(ID_INITQRY,brTargetEditor::OnText)
EVT_TEXT(ID_PARAMQRY,brTargetEditor::OnText)
EVT_TEXT(ID_CLEANQRY,brTargetEditor::OnText)
EVT_CHOICE(ID_TRIGGER,brTargetEditor::OnChoice)
END_EVENT_TABLE()

brTargetEditor::brTargetEditor(wxWindow *parent,BOLTdb *db,RECORD_ID recordId) :
wxDialog(parent,-1,"Stored Report Editor",wxDefaultPosition)
{	 
	this->db=db;
	this->recordId=recordId;
	SetFont(parent->GetFont());
	wxChoice *cTrigger;

	wxBoxSizer *topSizer=new wxBoxSizer(wxVERTICAL);
	topSizer->Add(new wxButton(this,wxID_CANCEL,"Done"),0,wxALIGN_CENTER|wxALL,5);
	wxBoxSizer *hSizer=new wxBoxSizer(wxHORIZONTAL);

	hSizer->Add(new wxStaticText(this,-1,"Label"),0,wxALL,5);
	hSizer->Add(new bcItem(this,ID_NAME,"storedReports","name",db,recordId),0,wxEXPAND|wxALL,5);

	hSizer->Add(new wxStaticText(this,-1,"Runs"),0,wxALL,5);

	QRY_ID qry;
	void *row;
	wxString tStr;

	//fill trigger choices
	tStr="select distinct name from reporttriggers order by name";
	cTrigger=new wxChoice(this,ID_TRIGGER);
	if (qry=db->Query(tStr.c_str(),tStr.Length()))
	{ 
		while (row=db->FetchRow(qry)) {
			cTrigger->Append(db->FetchQueryResult(qry,row,0));
		}
		tStr=db->GetValue("storedReports","trigger",this->recordId);
		if (!tStr.IsEmpty()&&(cTrigger->FindString(tStr)>-1))
			{	cTrigger->SetStringSelection(tStr); }
		db->FreeQuery(qry);
	}

	hSizer->Add(cTrigger,0,wxALL,5);

	topSizer->Add(hSizer,0,wxEXPAND|wxALL,5);
	topSizer->Add(new wxStaticText(this,-1,"Parameter Query"),0,wxALIGN_CENTER|wxALL,5);
	topSizer->Add(new bcItem(this,ID_PARAMQRY,"storedReports","paramQuery",db,recordId,wxDefaultValidator,wxTE_MULTILINE),0,wxEXPAND|wxALL,5);

	topSizer->Add(new wxStaticText(this,-1,"Pre-Run Query"),0,wxALIGN_CENTER|wxALL,5);
	topSizer->Add(new bcItem(this,ID_INITQRY,"storedReports","initQuery",db,recordId,wxDefaultValidator,wxTE_MULTILINE),0,wxEXPAND|wxALL,5);

	topSizer->Add(new wxStaticText(this,-1,"Post-Run Query"),0,wxALIGN_CENTER|wxALL,5);
	topSizer->Add(new bcItem(this,ID_CLEANQRY,"storedReports","cleanQuery",db,recordId,wxDefaultValidator,wxTE_MULTILINE),0,wxEXPAND|wxALL,5);

//	SetAutoLayout(TRUE);
	SetSizerAndFit(topSizer);
	topSizer->SetSizeHints( this );
	topSizer->Fit( this );
	Centre( wxBOTH );
	//TODO - this crap
	ShowModal();

};



void brTargetEditor::OnText(wxCommandEvent &event)
{
	bcItem *item;
	item = (bcItem *)event.GetEventObject();
	if (item) { item->OnEdit();}
}

void brTargetEditor::OnChoice(wxCommandEvent &event)
{
	wxString tStr;
	wxChoice *cTrigger;
	cTrigger=(wxChoice *)this->FindWindow(ID_TRIGGER);
	tStr=cTrigger->GetStringSelection();
	tStr.Prepend("'"); tStr.Append("'");
	db->SetValue("storedReports","trigger",this->recordId,tStr.c_str());
}
